<?php
require('fpdf/rotate.php');

class PDF extends PDF_Rotate
{
// Load data
function LoadData($file)
{
    // Read file lines
    $lines = file($file);
    $data = array();
    foreach($lines as $line)
        $data[] = explode(';',trim($line));
    return $data;
}
function Header(){
    if($this->PageNo()>1){
        $this->writeRecordHeading();
    }

}

function RotatedText($x, $y, $txt, $angle)
{
    //Text rotated around its origin
    $this->Rotate($angle,$x,$y);
    $this->Text($x,$y,$txt);
    $this->Rotate(0);
}


function Footer()
{
   /* // Position at 1.5 cm from bottom
    $this->SetY(-15);
    // Arial italic 8
    $this->SetFont('Arial','i',6);
    // Page number
    date_default_timezone_set('UTC');
    $this->Cell(0,10,'HMS: Vehicle Inspection Report  '.date('d-m-Y H:i:s'),0,0,'L');*/

    //for Pearsons
    $this->SetY(-21);
    $this->SetFont('Arial','',8);
    $this->Cell(0,11,'OFFICIAL - SENSITIVE',0,1,'C');
    $this->SetFont('Arial','',7);
    $this->Cell(0,0,'HMS Vehicle Condition Report',0,0,'R');
    $this->SetFont('Arial','',6);
    $this->Cell(0,5,chr(169).' 2015 Psion Consulting Ltd',0,0,'R');
    $this->Cell(0,10,'All rights reserved',0,1,'R');


    //$this->Cell(0,21,$this->PageNo().' of {nb}',0,0,'R');
    if((int)$_POST['progress']<100){
      $this->SetFont('Arial','B',50);
      $this->SetAlpha(0.6);
      $this->SetTextColor(255,142,153);
      $this->RotatedText(70,190,'D R A F T',45);
      $this->SetAlpha(1);
    }
    $this->SetFont('Arial','B',6);
}


function writeIntro($vals){

    /*$this->SetFont('Arial','',14);
    $this->AddPage();
    $this->SetTextColor(128,169,136);
    $this->SetDrawColor(255);
    
    $this->SetFont('','B');
    $this->ln();
    $this->ln();
        $this->Image('fpdf/header.jpg' , 173 , 8);
    $this->Cell(0,10,'HMS: VEHICLE INSPECTION REPORT',0,1,'C');*/

    $this->AddPage();
        $this->SetFont('Arial','',8);
    $this->SetTextColor(0,0,0);
    $this->SetDrawColor(255);
        $this->Cell(0,0,'OFFICIAL - SENSITIVE',0,1,'C');

        $this->SetFont('Arial','',14);
    $this->SetTextColor(128,169,136);
    $this->SetDrawColor(255);
    
    $this->SetFont('','B');
       // $this->Image('fpdf/pearson.png' , 10 , 8);
    $this->Cell(0,10,'HMS: VEHICLE CONDITION REPORT',0,1,'C');
    $this->SetFont('Arial','B',8);
    
    $this->Cell(0,10,'INSPECTION INTERVAL',0,0,'L');
    $this->Ln(7);
    $this->SetTextColor(255);
    $this->SetFillColor(128,169,136);
    $this->Cell(13,5,'Year',1,0,'L',true);
    $this->Cell(35,5,'Interval',1,0,'L',true);
    $this->Ln(5);
    $this->SetTextColor(0);
    $this->SetFillColor(181,220,185);
    $this->Cell(13,5,$_POST['year'],1,0,'L',true);
    $this->Cell(35,5,$_POST['interval'],1,0,'L',true);
    
    $this->Ln(7);
    
    $this->SetTextColor(128,169,136);
    $this->Cell(0,10,'INSPECTION DETAILS',0,0,'L');
    $this->Ln(7);
    $this->SetTextColor(255);
    $this->SetFillColor(128,169,136);
    $this->Cell(38,5,'Inspector',1,0,'L',true);
    $this->Cell(38,5,'Date',1,0,'L',true);
    $this->Cell(38,5,'Time',1,0,'L',true);
    $this->Cell(38,5,'Unit/Location',1,0,'L',true);
    $this->Ln(5);
    $this->SetTextColor(0);
    $this->SetFillColor(181,220,185);
    $this->Cell(38,5,$_POST['inspector'],1,0,'L',true);
    $this->Cell(38,5,$_POST['date'],1,0,'L',true);
    $this->Cell(38,5,$_POST['time'],1,0,'L',true);
    $this->Cell(38,5,$_POST['location'],1,0,'L',true);
    
     $this->Ln(7);

    
    $this->SetTextColor(128,169,136);
    $this->Cell(0,10,'VEHICLE INFORMATION',0,0,'L');
    $this->Ln(7);
    $this->SetTextColor(255);
    $this->SetFillColor(128,169,136);
    $this->Cell(38,5,'Type/Variant',1,0,'L',true);
    $this->Cell(38,5,'Usage(kms)',1,0,'L',true);
    $this->Cell(38,5,'VRN',1,0,'L',true);
        $this->Cell(38,5,'',0,0,'L',false);
        $this->Cell(38,5,'Inspection Progress',1,0,'L',true);
    $this->Ln(5);
    $this->SetTextColor(0);
    $this->SetFillColor(181,220,185);
    $this->Cell(38,5,$_POST['type'],1,0,'L',true);
    $this->Cell(38,5,$_POST['usage'],1,0,'L',true);
    $this->Cell(38,5,$_POST['vrn'],1,0,'L',true);
        $this->Cell(38,5,'',0,0,'L',false);
        $this->Cell(38,5,$_POST['progress']."%",1,0,'L',true);
    
    $this->Ln(7);
    
    $this->SetTextColor(128,169,136);
    $this->Cell(0,10,'INSPECTION RESULTS',0,0,'L');
    $this->Ln(7);
    $this->SetTextColor(255);
    $this->SetFillColor(128,169,136);
    $this->Cell(48,5,'Inspection Results',1,0,'L',true);
    $this->Cell(48,5,'Summary of Failures',1,0,'L',true);
    $this->Cell(48,5,'Summary of Risks(class)',1,0,'L',true);
    $this->Cell(48,5,'Scores (100=best)',1,0,'L',true);
    $this->Ln(5);
    $this->SetTextColor(0);
    $this->SetFillColor(181,220,185);
    $this->SetFont('Arial','B',6);
    $this->Cell(16,4,'Fully','LR',0,'L',true);
    $this->Cell(16,4,'Limited','LR',0,'L',true);
    $this->Cell(16,4,'Non','LR',0,'L',true);  
    $this->Cell(16,4,'Total','LR',0,'L',true);
    $this->Cell(16,4,'Operations','LR',0,'L',true);
    $this->Cell(16,4,'Training','LR',0,'L',true);
    $this->Cell(12,4,'Red(A)','LR',0,'L',true);
    $this->Cell(12,4,'Amber(B)','LR',0,'L',true);
    $this->Cell(12,4,'Yellow(C)','LR',0,'L',true);
    $this->Cell(12,4,'Green(D)','LR',0,'L',true);
    $this->Cell(16,4,'Safety','LR',0,'L',true);
    $this->Cell(16,4,'Mission','LR',0,'L',true);
    $this->Cell(16,4,'Overall','LR',0,'L',true);
    
    $this->Ln(4);
    
    $this->Cell(16,4,'operational','LR',0,'L',true);
    $this->Cell(16,4,'role','LR',0,'L',true);
    $this->Cell(16,4,'operational','LR',0,'L',true);
    $this->Cell(16,4,'Failures','LR',0,'L',true);
    $this->Cell(16,4,'','LR',0,'L',true);
    $this->Cell(16,4,'','LR',0,'L',true);
    $this->Cell(12,4,'','LR',0,'L',true);
    $this->Cell(12,4,'','LR',0,'L',true);
    $this->Cell(12,4,'','LR',0,'L',true);
    $this->Cell(12,4,'','LR',0,'L',true);
    $this->Cell(16,4,'','LR',0,'L',true);
    $this->Cell(16,4,'','LR',0,'L',true);
    $this->Cell(16,4,'','LR',0,'L',true);
    
    $this->Ln(4);

        if($_POST['missioncolour']!='none')
    $this->SetFillColor(0,255,0);
        else
        $this->SetFillColor(224,255,255);
    $this->Cell(16,4,'','LR',0,'L',true);
    if($_POST['trainingonlycolour']!='none')
    $this->SetFillColor(255,190,0);
        else
        $this->SetFillColor(224,255,255);
    $this->Cell(16,4,'','LR',0,'L',true);
    if($_POST['nonopcolour']!='none')
    $this->SetFillColor(255,0,0);
        else
        $this->SetFillColor(224,255,255);
    $this->Cell(16,4,'','LR',0,'L',true);
    
    $this->SetFillColor(224,255,255);
    $this->Cell(16,4,$_POST['totalfailures'],'LR',0,'L',true);
    $this->Cell(16,4,$_POST['operations'],'LR',0,'L',true);
    $this->Cell(16,4,$_POST['training'],'LR',0,'L',true);
    $this->Cell(12,4,$_POST['red'],'LR',0,'L',true);
    $this->Cell(12,4,$_POST['amber'],'LR',0,'L',true);
    $this->Cell(12,4,$_POST['yellow'],'LR',0,'L',true);
    $this->Cell(12,4,$_POST['green'],'LR',0,'L',true);
    $this->Cell(16,4,$_POST['safety'],'LR',0,'L',true);
    $this->Cell(16,4,$_POST['mission'],'LR',0,'L',true);
    $this->Cell(16,4,$_POST['overall'],'LR',0,'L',true);
    
    $this->Ln(7);
    $this->SetFont('Arial','B',10);
    $this->SetTextColor(128,169,136);
    $this->Cell(0,10,'INSPECTION RECORDS',0,0,'L');
    $this->Ln(7);
    $this->writeRecordHeading();
}

function writeRecordHeading(){
    
    $this->SetFont('Arial','B',6);
    $this->SetTextColor(0);
    $this->SetFillColor(181,220,185);
    $this->SetDrawColor(0);
    $this->Cell(24,3,'SSI','LRT',0,'L',true);
    $this->Cell(13,3,'SSI','LRT',0,'C',true);
    $this->Cell(47,3,'SSI Designation','LRT',0,'C',true);
    $this->Cell(47,3,'Recorded Observations','LRT',0,'C',true);
    $this->Cell(12,3,'Any','LRT',0,'C',true);
    $this->Cell(12,3,'Total','LRT',0,'C',true);
    $this->Cell(12,3,'Max','LRT',0,'C',true);
    $this->Cell(12,3,'Flaw','LRT',0,'C',true);
    $this->Cell(12,3,'Results','LRT',0,'C',true);
    $this->Ln(3);
    $this->Cell(24,3,'ID','LR',0,'L',true);
    $this->Cell(13,3,'Ref.','LR',0,'C',true);
    $this->Cell(47,3,'','LR',0,'C',true);
    $this->Cell(47,3,'','LR',0,'C',true);
    $this->Cell(12,3,'Flaws','LR',0,'C',true);
    $this->Cell(12,3,'','LR',0,'C',true);
    $this->Cell(12,3,'','LR',0,'C',true);
    $this->Cell(12,3,'Size %','LR',0,'C',true);
    $this->Cell(12,3,'','LR',0,'C',true);
    $this->Ln(3);
    $this->Cell(24,3,'','LR',0,'L',true);
    $this->Cell(13,3,'','LR',0,'C',true);
    $this->Cell(47,3,'','LR',0,'C',true);
    $this->Cell(47,3,'','LR',0,'C',true);
    $this->Cell(12,3,'','LRT',0,'C',true);
    $this->Cell(12,3,'Flaw','LRT',0,'C',true);
    $this->Cell(12,3,'Flaw','LRT',0,'C',true);
    $this->Cell(12,3,'','LRT',0,'C',true);
    $this->Cell(12,3,'Pass/','LRT',0,'C',true);
    $this->Ln(3);
    $this->Cell(24,3,'','LRB',0,'L',true);
    $this->Cell(13,3,'','LRB',0,'C',true);
    $this->Cell(47,3,'','LRB',0,'C',true);
    $this->Cell(47,3,'','LRB',0,'C',true);
    $this->Cell(12,3,'','LRB',0,'C',true);
    $this->Cell(12,3,'Length','LRB',0,'C',true);
    $this->Cell(12,3,'Depth','LRB',0,'C',true);
    $this->Cell(12,3,'','LRB',0,'C',true);
    $this->Cell(12,3,'Fail','LRB',0,'C',true);
    $this->Ln(3);
}
function writeRecord(){
        
    $this->SetFont('Arial','B',6);
    $this->SetTextColor(0);
    $this->SetFillColor(255);
    $this->SetDrawColor(0);
    $this->MultiCell(12,3,'','LRB',0,'L',true);
    $this->MultiCell(13,3,'','LRB',0,'C',true);
    $this->MultiCell(47,3,'','LRB',0,'C',true);
    $this->MultiCell(12,3,'','LRB',0,'C',true);
    $this->MultiCell(47,3,'A whole lot of stuff in here so probably too big to fit','LRB',0,'C',true);
    $this->MultiCell(12,3,'','LRB',0,'C',true);
    $this->MultiCell(12,3,'Length','LRB',0,'C',true);
    $this->MultiCell(12,3,'Depth','LRB',0,'C',true);
    $this->MultiCell(12,3,'','LRB',0,'C',true);
    $this->MultiCell(12,3,'Fail','LRB',0,'C',true);
    $this->Ln(3);

}

}

$pdf = new PDF();
$json='{"year":"2012","interval":"12Month"}';
$pdf->AliasNbPages();
//$vals=json_decode($json,true);
$pdf->writeIntro($_POST);
$pdf->SetFont('Arial','B',6);
$pdf->SetTextColor(0);
$pdf->SetFillColor(255);
$pdf->SetDrawColor(0);
$pdf->tablewidths = array(24, 13, 47, 47, 12, 12, 12, 12, 12);
for($i=0;$i<count($_POST['ssiid']);$i++) {
    $data[] = array($_POST['ssiid'][$i], $_POST['ssiref'][$i], $_POST['ssides'][$i], $_POST['observation'][$i], $_POST['anyflaws'][$i],$_POST['flawtotal'][$i],$_POST['flawmax'][$i],$_POST['flawsize'][$i],$_POST['ssiresult'][$i]);
}
$pdf->morepagestable($data,3);

$pdf->Output();
?>